import { Link, useLocation } from 'react-router-dom'
import { Palette } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="container">
          <div className="header-content">
            <Link to="/" className="logo">
              <div className="logo-icon-wrapper">
                <Palette size={32} strokeWidth={2.5} />
                <div className="logo-glow"></div>
              </div>
              <span className="logo-text">ArtStudio</span>
            </Link>
            <nav className="nav">
              <Link 
                to="/" 
                className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои занятия
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

